@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtPolicyCreationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMware Cbt policy creation input.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency (in minutes).
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency (in minutes).
 * @property instanceType The class type.
 * Expected value is 'VMwareCbt'.
 * @property recoveryPointHistoryInMinutes The duration in minutes until which the recovery points need to be stored.
 */
public data class VMwareCbtPolicyCreationInputArgs(
    public val appConsistentFrequencyInMinutes: Output<Int>? = null,
    public val crashConsistentFrequencyInMinutes: Output<Int>? = null,
    public val instanceType: Output<String>,
    public val recoveryPointHistoryInMinutes: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtPolicyCreationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtPolicyCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtPolicyCreationInputArgs.builder()
            .appConsistentFrequencyInMinutes(appConsistentFrequencyInMinutes?.applyValue({ args0 -> args0 }))
            .crashConsistentFrequencyInMinutes(
                crashConsistentFrequencyInMinutes?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .recoveryPointHistoryInMinutes(
                recoveryPointHistoryInMinutes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VMwareCbtPolicyCreationInputArgs].
 */
@PulumiTagMarker
public class VMwareCbtPolicyCreationInputArgsBuilder internal constructor() {
    private var appConsistentFrequencyInMinutes: Output<Int>? = null

    private var crashConsistentFrequencyInMinutes: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var recoveryPointHistoryInMinutes: Output<Int>? = null

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("cprafyixluoukfnd")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.appConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("lrrspvklgfgqstfc")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.crashConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The class type.
     * Expected value is 'VMwareCbt'.
     */
    @JvmName("omsnvhxcpdxpiksg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The duration in minutes until which the recovery points need to be stored.
     */
    @JvmName("mbvjucxyjaamolfd")
    public suspend fun recoveryPointHistoryInMinutes(`value`: Output<Int>) {
        this.recoveryPointHistoryInMinutes = value
    }

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("ggdeamcbkeflchwa")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("rurwtopntyfpcdiw")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crashConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'VMwareCbt'.
     */
    @JvmName("nilwjncgkebfitto")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The duration in minutes until which the recovery points need to be stored.
     */
    @JvmName("mekikffxiktcdqur")
    public suspend fun recoveryPointHistoryInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointHistoryInMinutes = mapped
    }

    internal fun build(): VMwareCbtPolicyCreationInputArgs = VMwareCbtPolicyCreationInputArgs(
        appConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes,
        crashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        recoveryPointHistoryInMinutes = recoveryPointHistoryInMinutes,
    )
}
