@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VMwareV2FabricCreationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMwareV2 fabric provider specific settings.
 * @property instanceType Gets the class type.
 * Expected value is 'VMwareV2'.
 * @property migrationSolutionId The ARM Id of the migration solution.
 * @property physicalSiteId The ARM Id of the physical site.
 * @property vmwareSiteId The ARM Id of the VMware site.
 */
public data class VMwareV2FabricCreationInputArgs(
    public val instanceType: Output<String>,
    public val migrationSolutionId: Output<String>,
    public val physicalSiteId: Output<String>? = null,
    public val vmwareSiteId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VMwareV2FabricCreationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VMwareV2FabricCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VMwareV2FabricCreationInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .migrationSolutionId(migrationSolutionId.applyValue({ args0 -> args0 }))
            .physicalSiteId(physicalSiteId?.applyValue({ args0 -> args0 }))
            .vmwareSiteId(vmwareSiteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareV2FabricCreationInputArgs].
 */
@PulumiTagMarker
public class VMwareV2FabricCreationInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var migrationSolutionId: Output<String>? = null

    private var physicalSiteId: Output<String>? = null

    private var vmwareSiteId: Output<String>? = null

    /**
     * @param value Gets the class type.
     * Expected value is 'VMwareV2'.
     */
    @JvmName("chyfpxcysrsmhwqj")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The ARM Id of the migration solution.
     */
    @JvmName("pvvhhlyrqkkpshfq")
    public suspend fun migrationSolutionId(`value`: Output<String>) {
        this.migrationSolutionId = value
    }

    /**
     * @param value The ARM Id of the physical site.
     */
    @JvmName("nrkouvmdaoymwgiq")
    public suspend fun physicalSiteId(`value`: Output<String>) {
        this.physicalSiteId = value
    }

    /**
     * @param value The ARM Id of the VMware site.
     */
    @JvmName("weqyucyumompoutb")
    public suspend fun vmwareSiteId(`value`: Output<String>) {
        this.vmwareSiteId = value
    }

    /**
     * @param value Gets the class type.
     * Expected value is 'VMwareV2'.
     */
    @JvmName("ghdedckvlmxltytl")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The ARM Id of the migration solution.
     */
    @JvmName("ergcfbqcxynvtnsa")
    public suspend fun migrationSolutionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSolutionId = mapped
    }

    /**
     * @param value The ARM Id of the physical site.
     */
    @JvmName("nrmyxowgngvtvxoc")
    public suspend fun physicalSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalSiteId = mapped
    }

    /**
     * @param value The ARM Id of the VMware site.
     */
    @JvmName("pbslvjqlklbvxkue")
    public suspend fun vmwareSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmwareSiteId = mapped
    }

    internal fun build(): VMwareV2FabricCreationInputArgs = VMwareV2FabricCreationInputArgs(
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        migrationSolutionId = migrationSolutionId ?: throw PulumiNullFieldException("migrationSolutionId"),
        physicalSiteId = physicalSiteId,
        vmwareSiteId = vmwareSiteId,
    )
}
