@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the vault.
 * @property encryption Customer Managed Key details of the resource.
 * @property monitoringSettings Monitoring Settings of the vault
 * @property publicNetworkAccess property to enable or disable resource provider inbound network traffic from public clients
 * @property restoreSettings Restore Settings of the vault
 * @property securitySettings Security Settings of the vault
 */
public data class VaultPropertiesArgs(
    public val encryption: Output<VaultPropertiesEncryptionArgs>? = null,
    public val monitoringSettings: Output<MonitoringSettingsArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val restoreSettings: Output<RestoreSettingsArgs>? = null,
    public val securitySettings: Output<SecuritySettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitoringSettings(
                monitoringSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .restoreSettings(restoreSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securitySettings(
                securitySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VaultPropertiesArgs].
 */
@PulumiTagMarker
public class VaultPropertiesArgsBuilder internal constructor() {
    private var encryption: Output<VaultPropertiesEncryptionArgs>? = null

    private var monitoringSettings: Output<MonitoringSettingsArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var restoreSettings: Output<RestoreSettingsArgs>? = null

    private var securitySettings: Output<SecuritySettingsArgs>? = null

    /**
     * @param value Customer Managed Key details of the resource.
     */
    @JvmName("amvjpbgpfoqflxvu")
    public suspend fun encryption(`value`: Output<VaultPropertiesEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Monitoring Settings of the vault
     */
    @JvmName("bvwglxgvnjuhicct")
    public suspend fun monitoringSettings(`value`: Output<MonitoringSettingsArgs>) {
        this.monitoringSettings = value
    }

    /**
     * @param value property to enable or disable resource provider inbound network traffic from public clients
     */
    @JvmName("wpqolcqlitjgodjf")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Restore Settings of the vault
     */
    @JvmName("krqtfynxxnoijwpx")
    public suspend fun restoreSettings(`value`: Output<RestoreSettingsArgs>) {
        this.restoreSettings = value
    }

    /**
     * @param value Security Settings of the vault
     */
    @JvmName("vkdlbfyvjrrofsjx")
    public suspend fun securitySettings(`value`: Output<SecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value Customer Managed Key details of the resource.
     */
    @JvmName("bstylqbodlihmjtr")
    public suspend fun encryption(`value`: VaultPropertiesEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Customer Managed Key details of the resource.
     */
    @JvmName("tdtxrdpctkapcwbo")
    public suspend fun encryption(argument: suspend VaultPropertiesEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = VaultPropertiesEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Monitoring Settings of the vault
     */
    @JvmName("giwbcgxhpdrugiub")
    public suspend fun monitoringSettings(`value`: MonitoringSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringSettings = mapped
    }

    /**
     * @param argument Monitoring Settings of the vault
     */
    @JvmName("eyeygnkjesdgddhr")
    public suspend
    fun monitoringSettings(argument: suspend MonitoringSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitoringSettings = mapped
    }

    /**
     * @param value property to enable or disable resource provider inbound network traffic from public clients
     */
    @JvmName("rmwfemhkgdeudvje")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value property to enable or disable resource provider inbound network traffic from public clients
     */
    @JvmName("cpxelmvgxsbpdels")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value property to enable or disable resource provider inbound network traffic from public clients
     */
    @JvmName("tuurwfcvbseflrtv")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Restore Settings of the vault
     */
    @JvmName("pcrsimffhwsyrovo")
    public suspend fun restoreSettings(`value`: RestoreSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreSettings = mapped
    }

    /**
     * @param argument Restore Settings of the vault
     */
    @JvmName("vrwhfjbofcdcqbfn")
    public suspend fun restoreSettings(argument: suspend RestoreSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RestoreSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.restoreSettings = mapped
    }

    /**
     * @param value Security Settings of the vault
     */
    @JvmName("kqdmyvcrrjumwtfu")
    public suspend fun securitySettings(`value`: SecuritySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument Security Settings of the vault
     */
    @JvmName("sgdsxumfggfhqbdo")
    public suspend fun securitySettings(argument: suspend SecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    internal fun build(): VaultPropertiesArgs = VaultPropertiesArgs(
        encryption = encryption,
        monitoringSettings = monitoringSettings,
        publicNetworkAccess = publicNetworkAccess,
        restoreSettings = restoreSettings,
        securitySettings = securitySettings,
    )
}
