@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.WorkloadInquiryDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of an inquired protectable item.
 * @property inquiryValidation Inquiry validation such as permissions and other backup validations.
 * @property itemCount Contains the protectable item Count inside this Container.
 * @property type Type of the Workload such as SQL, Oracle etc.
 */
public data class WorkloadInquiryDetailsArgs(
    public val inquiryValidation: Output<InquiryValidationArgs>? = null,
    public val itemCount: Output<Double>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.WorkloadInquiryDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.WorkloadInquiryDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.WorkloadInquiryDetailsArgs.builder()
            .inquiryValidation(inquiryValidation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .itemCount(itemCount?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadInquiryDetailsArgs].
 */
@PulumiTagMarker
public class WorkloadInquiryDetailsArgsBuilder internal constructor() {
    private var inquiryValidation: Output<InquiryValidationArgs>? = null

    private var itemCount: Output<Double>? = null

    private var type: Output<String>? = null

    /**
     * @param value Inquiry validation such as permissions and other backup validations.
     */
    @JvmName("pwtgmowergmicffe")
    public suspend fun inquiryValidation(`value`: Output<InquiryValidationArgs>) {
        this.inquiryValidation = value
    }

    /**
     * @param value Contains the protectable item Count inside this Container.
     */
    @JvmName("tqowdaidgomicsxd")
    public suspend fun itemCount(`value`: Output<Double>) {
        this.itemCount = value
    }

    /**
     * @param value Type of the Workload such as SQL, Oracle etc.
     */
    @JvmName("tflmggmnacijxuyn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Inquiry validation such as permissions and other backup validations.
     */
    @JvmName("odbbpcptqduoddlf")
    public suspend fun inquiryValidation(`value`: InquiryValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inquiryValidation = mapped
    }

    /**
     * @param argument Inquiry validation such as permissions and other backup validations.
     */
    @JvmName("msydkcviyiukihgn")
    public suspend fun inquiryValidation(argument: suspend InquiryValidationArgsBuilder.() -> Unit) {
        val toBeMapped = InquiryValidationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inquiryValidation = mapped
    }

    /**
     * @param value Contains the protectable item Count inside this Container.
     */
    @JvmName("rfsfwjhhjsgjahiu")
    public suspend fun itemCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itemCount = mapped
    }

    /**
     * @param value Type of the Workload such as SQL, Oracle etc.
     */
    @JvmName("vlvbukpjnyqdgnwg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WorkloadInquiryDetailsArgs = WorkloadInquiryDetailsArgs(
        inquiryValidation = inquiryValidation,
        itemCount = itemCount,
        type = type,
    )
}
