@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A2A provider specific settings.
 * @property fabricObjectId The fabric specific object Id of the virtual machine.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2ACrossClusterMigration'.
 * @property lifecycleId An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
 * @property osType The type of operating system.
 * @property primaryFabricLocation Primary fabric location.
 * @property vmProtectionState The protection state for the vm.
 * @property vmProtectionStateDescription The protection state description for the vm.
 */
public data class A2ACrossClusterMigrationReplicationDetailsResponse(
    public val fabricObjectId: String? = null,
    public val instanceType: String,
    public val lifecycleId: String? = null,
    public val osType: String? = null,
    public val primaryFabricLocation: String? = null,
    public val vmProtectionState: String? = null,
    public val vmProtectionStateDescription: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2ACrossClusterMigrationReplicationDetailsResponse):
            A2ACrossClusterMigrationReplicationDetailsResponse =
            A2ACrossClusterMigrationReplicationDetailsResponse(
                fabricObjectId = javaType.fabricObjectId().map({ args0 -> args0 }).orElse(null),
                instanceType = javaType.instanceType(),
                lifecycleId = javaType.lifecycleId().map({ args0 -> args0 }).orElse(null),
                osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
                primaryFabricLocation = javaType.primaryFabricLocation().map({ args0 -> args0 }).orElse(null),
                vmProtectionState = javaType.vmProtectionState().map({ args0 -> args0 }).orElse(null),
                vmProtectionStateDescription = javaType.vmProtectionStateDescription().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
