@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ExtendedLocation details data.
 * @property initialPrimaryExtendedLocation The initial primary ExtendedLocation.
 * @property initialPrimaryFabricLocation Initial primary fabric location info.
 * @property initialPrimaryZone The initial source zone info.
 * @property initialRecoveryExtendedLocation The initial recovery ExtendedLocation.
 * @property initialRecoveryFabricLocation The initial recovery fabric location info.
 * @property initialRecoveryZone The initial target zone info.
 * @property primaryExtendedLocation The primary ExtendedLocation.
 * @property primaryFabricLocation Primary fabric location info.
 * @property primaryZone Source zone info.
 * @property recoveryExtendedLocation The recovery ExtendedLocation.
 * @property recoveryFabricLocation The recovery fabric location info.
 * @property recoveryZone The target zone info.
 */
public data class A2AFabricSpecificLocationDetailsResponse(
    public val initialPrimaryExtendedLocation: ExtendedLocationResponse? = null,
    public val initialPrimaryFabricLocation: String? = null,
    public val initialPrimaryZone: String? = null,
    public val initialRecoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val initialRecoveryFabricLocation: String? = null,
    public val initialRecoveryZone: String? = null,
    public val primaryExtendedLocation: ExtendedLocationResponse? = null,
    public val primaryFabricLocation: String? = null,
    public val primaryZone: String? = null,
    public val recoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val recoveryFabricLocation: String? = null,
    public val recoveryZone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AFabricSpecificLocationDetailsResponse):
            A2AFabricSpecificLocationDetailsResponse = A2AFabricSpecificLocationDetailsResponse(
            initialPrimaryExtendedLocation = javaType.initialPrimaryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialPrimaryFabricLocation = javaType.initialPrimaryFabricLocation().map({ args0 ->
                args0
            }).orElse(null),
            initialPrimaryZone = javaType.initialPrimaryZone().map({ args0 -> args0 }).orElse(null),
            initialRecoveryExtendedLocation = javaType.initialRecoveryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialRecoveryFabricLocation = javaType.initialRecoveryFabricLocation().map({ args0 ->
                args0
            }).orElse(null),
            initialRecoveryZone = javaType.initialRecoveryZone().map({ args0 -> args0 }).orElse(null),
            primaryExtendedLocation = javaType.primaryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryFabricLocation = javaType.primaryFabricLocation().map({ args0 -> args0 }).orElse(null),
            primaryZone = javaType.primaryZone().map({ args0 -> args0 }).orElse(null),
            recoveryExtendedLocation = javaType.recoveryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recoveryFabricLocation = javaType.recoveryFabricLocation().map({ args0 -> args0 }).orElse(null),
            recoveryZone = javaType.recoveryZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
