@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A2A unprotected disk details.
 * @property diskAutoProtectionStatus A value indicating whether the disk auto protection is enabled.
 * @property diskLunId The source lun Id for the data disk.
 */
public data class A2AUnprotectedDiskDetailsResponse(
    public val diskAutoProtectionStatus: String? = null,
    public val diskLunId: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AUnprotectedDiskDetailsResponse):
            A2AUnprotectedDiskDetailsResponse = A2AUnprotectedDiskDetailsResponse(
            diskAutoProtectionStatus = javaType.diskAutoProtectionStatus().map({ args0 -> args0 }).orElse(null),
            diskLunId = javaType.diskLunId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
