@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Critical past job details of the migration item.
 * @property jobId The ARM Id of the job being executed.
 * @property jobName The job name.
 * @property jobStatus The job state.
 * @property startTime The start time of the job.
 */
public data class CriticalJobHistoryDetailsResponse(
    public val jobId: String,
    public val jobName: String,
    public val jobStatus: String,
    public val startTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.CriticalJobHistoryDetailsResponse):
            CriticalJobHistoryDetailsResponse = CriticalJobHistoryDetailsResponse(
            jobId = javaType.jobId(),
            jobName = javaType.jobName(),
            jobStatus = javaType.jobStatus(),
            startTime = javaType.startTime(),
        )
    }
}
