@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Current scenario details of the protected entity.
 * @property jobId ARM Id of the job being executed.
 * @property scenarioName Scenario name.
 * @property startTime Start time of the workflow.
 */
public data class CurrentScenarioDetailsResponse(
    public val jobId: String? = null,
    public val scenarioName: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.CurrentScenarioDetailsResponse):
            CurrentScenarioDetailsResponse = CurrentScenarioDetailsResponse(
            jobId = javaType.jobId().map({ args0 -> args0 }).orElse(null),
            scenarioName = javaType.scenarioName().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
