@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Fabric properties.
 * @property bcdrState BCDR state of the fabric.
 * @property customDetails Fabric specific settings.
 * @property encryptionDetails Encryption details for the fabric.
 * @property friendlyName Friendly name of the fabric.
 * @property health Health of fabric.
 * @property healthErrorDetails Fabric health error details.
 * @property internalIdentifier Dra Registration Id.
 * @property rolloverEncryptionDetails Rollover encryption details for the fabric.
 */
public data class FabricPropertiesResponse(
    public val bcdrState: String? = null,
    public val customDetails: Any? = null,
    public val encryptionDetails: EncryptionDetailsResponse? = null,
    public val friendlyName: String? = null,
    public val health: String? = null,
    public val healthErrorDetails: List<HealthErrorResponse>? = null,
    public val internalIdentifier: String? = null,
    public val rolloverEncryptionDetails: EncryptionDetailsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.FabricPropertiesResponse):
            FabricPropertiesResponse = FabricPropertiesResponse(
            bcdrState = javaType.bcdrState().map({ args0 -> args0 }).orElse(null),
            customDetails = javaType.customDetails().map({ args0 -> args0 }).orElse(null),
            encryptionDetails = javaType.encryptionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.EncryptionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            health = javaType.health().map({ args0 -> args0 }).orElse(null),
            healthErrorDetails = javaType.healthErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            internalIdentifier = javaType.internalIdentifier().map({ args0 -> args0 }).orElse(null),
            rolloverEncryptionDetails = javaType.rolloverEncryptionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.EncryptionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
