@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Fabric definition.
 * @property id Resource Id
 * @property location Resource Location
 * @property name Resource Name
 * @property properties Fabric related data.
 * @property type Resource Type
 */
public data class GetReplicationFabricResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: FabricPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GetReplicationFabricResult):
            GetReplicationFabricResult = GetReplicationFabricResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.FabricPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
