@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Hyper-V Replica Blue specific protection profile details.
 * @property allowedAuthenticationType A value indicating the authentication type.
 * @property applicationConsistentSnapshotFrequencyInHours A value indicating the application consistent frequency.
 * @property compression A value indicating whether compression has to be enabled.
 * @property initialReplicationMethod A value indicating whether IR is online.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'HyperVReplica2012'.
 * @property offlineReplicationExportPath A value indicating the offline IR export path.
 * @property offlineReplicationImportPath A value indicating the offline IR import path.
 * @property onlineReplicationStartTime A value indicating the online IR start time.
 * @property recoveryPoints A value indicating the number of recovery points.
 * @property replicaDeletionOption A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
 * @property replicationPort A value indicating the recovery HTTPS port.
 */
public data class HyperVReplicaPolicyDetailsResponse(
    public val allowedAuthenticationType: Int? = null,
    public val applicationConsistentSnapshotFrequencyInHours: Int? = null,
    public val compression: String? = null,
    public val initialReplicationMethod: String? = null,
    public val instanceType: String,
    public val offlineReplicationExportPath: String? = null,
    public val offlineReplicationImportPath: String? = null,
    public val onlineReplicationStartTime: String? = null,
    public val recoveryPoints: Int? = null,
    public val replicaDeletionOption: String? = null,
    public val replicationPort: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVReplicaPolicyDetailsResponse):
            HyperVReplicaPolicyDetailsResponse = HyperVReplicaPolicyDetailsResponse(
            allowedAuthenticationType = javaType.allowedAuthenticationType().map({ args0 ->
                args0
            }).orElse(null),
            applicationConsistentSnapshotFrequencyInHours = javaType.applicationConsistentSnapshotFrequencyInHours().map({ args0 ->
                args0
            }).orElse(null),
            compression = javaType.compression().map({ args0 -> args0 }).orElse(null),
            initialReplicationMethod = javaType.initialReplicationMethod().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            offlineReplicationExportPath = javaType.offlineReplicationExportPath().map({ args0 ->
                args0
            }).orElse(null),
            offlineReplicationImportPath = javaType.offlineReplicationImportPath().map({ args0 ->
                args0
            }).orElse(null),
            onlineReplicationStartTime = javaType.onlineReplicationStartTime().map({ args0 ->
                args0
            }).orElse(null),
            recoveryPoints = javaType.recoveryPoints().map({ args0 -> args0 }).orElse(null),
            replicaDeletionOption = javaType.replicaDeletionOption().map({ args0 -> args0 }).orElse(null),
            replicationPort = javaType.replicationPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
