@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity provider details.
 * @property aadAuthority The base authority for Azure Active Directory authentication.
 * @property applicationId The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property audience The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property objectId The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property tenantId The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 */
public data class IdentityProviderDetailsResponse(
    public val aadAuthority: String? = null,
    public val applicationId: String? = null,
    public val audience: String? = null,
    public val objectId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.IdentityProviderDetailsResponse):
            IdentityProviderDetailsResponse = IdentityProviderDetailsResponse(
            aadAuthority = javaType.aadAuthority().map({ args0 -> args0 }).orElse(null),
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
