@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * InMage Azure v2 specific protection profile details.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency in minutes.
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency in minutes.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'InMageAzureV2'.
 * @property multiVmSyncStatus A value indicating whether multi-VM sync has to be enabled.
 * @property recoveryPointHistory The duration in minutes until which the recovery points need to be stored.
 * @property recoveryPointThresholdInMinutes The recovery point threshold in minutes.
 */
public data class InMageAzureV2PolicyDetailsResponse(
    public val appConsistentFrequencyInMinutes: Int? = null,
    public val crashConsistentFrequencyInMinutes: Int? = null,
    public val instanceType: String,
    public val multiVmSyncStatus: String? = null,
    public val recoveryPointHistory: Int? = null,
    public val recoveryPointThresholdInMinutes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageAzureV2PolicyDetailsResponse):
            InMageAzureV2PolicyDetailsResponse = InMageAzureV2PolicyDetailsResponse(
            appConsistentFrequencyInMinutes = javaType.appConsistentFrequencyInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            crashConsistentFrequencyInMinutes = javaType.crashConsistentFrequencyInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            instanceType = javaType.instanceType(),
            multiVmSyncStatus = javaType.multiVmSyncStatus().map({ args0 -> args0 }).orElse(null),
            recoveryPointHistory = javaType.recoveryPointHistory().map({ args0 -> args0 }).orElse(null),
            recoveryPointThresholdInMinutes = javaType.recoveryPointThresholdInMinutes().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
