@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * InMageAzureV2 switch provider details.
 * @property targetApplianceId The target appliance Id.
 * @property targetFabricId The target fabric Id.
 * @property targetResourceId The target resource Id.
 * @property targetVaultId The target vault Id.
 */
public data class InMageAzureV2SwitchProviderDetailsResponse(
    public val targetApplianceId: String,
    public val targetFabricId: String,
    public val targetResourceId: String,
    public val targetVaultId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageAzureV2SwitchProviderDetailsResponse):
            InMageAzureV2SwitchProviderDetailsResponse = InMageAzureV2SwitchProviderDetailsResponse(
            targetApplianceId = javaType.targetApplianceId(),
            targetFabricId = javaType.targetFabricId(),
            targetResourceId = javaType.targetResourceId(),
            targetVaultId = javaType.targetVaultId(),
        )
    }
}
