@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InMageRcm fabric specific details.
 * @property agentDetails The list of agent details.
 * @property controlPlaneUri The control plane Uri.
 * @property dataPlaneUri The data plane Uri.
 * @property dras The list of DRAs.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'InMageRcm'.
 * @property marsAgents The list of Mars agents.
 * @property physicalSiteId The ARM Id of the physical site.
 * @property processServers The list of process servers.
 * @property pushInstallers The list of push installers.
 * @property rcmProxies The list of RCM proxies.
 * @property replicationAgents The list of replication agents.
 * @property reprotectAgents The list of reprotect agents.
 * @property serviceContainerId The service container Id.
 * @property serviceEndpoint The service endpoint.
 * @property serviceResourceId The service resource Id.
 * @property sourceAgentIdentityDetails The source agent identity details.
 * @property vmwareSiteId The ARM Id of the VMware site.
 */
public data class InMageRcmFabricSpecificDetailsResponse(
    public val agentDetails: List<AgentDetailsResponse>,
    public val controlPlaneUri: String,
    public val dataPlaneUri: String,
    public val dras: List<DraDetailsResponse>,
    public val instanceType: String,
    public val marsAgents: List<MarsAgentDetailsResponse>,
    public val physicalSiteId: String,
    public val processServers: List<ProcessServerDetailsResponse>,
    public val pushInstallers: List<PushInstallerDetailsResponse>,
    public val rcmProxies: List<RcmProxyDetailsResponse>,
    public val replicationAgents: List<ReplicationAgentDetailsResponse>,
    public val reprotectAgents: List<ReprotectAgentDetailsResponse>,
    public val serviceContainerId: String,
    public val serviceEndpoint: String,
    public val serviceResourceId: String,
    public val sourceAgentIdentityDetails: IdentityProviderDetailsResponse? = null,
    public val vmwareSiteId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFabricSpecificDetailsResponse):
            InMageRcmFabricSpecificDetailsResponse = InMageRcmFabricSpecificDetailsResponse(
            agentDetails = javaType.agentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.AgentDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            controlPlaneUri = javaType.controlPlaneUri(),
            dataPlaneUri = javaType.dataPlaneUri(),
            dras = javaType.dras().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DraDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
            marsAgents = javaType.marsAgents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.MarsAgentDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            physicalSiteId = javaType.physicalSiteId(),
            processServers = javaType.processServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ProcessServerDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            pushInstallers = javaType.pushInstallers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.PushInstallerDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            rcmProxies = javaType.rcmProxies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RcmProxyDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            replicationAgents = javaType.replicationAgents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReplicationAgentDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            reprotectAgents = javaType.reprotectAgents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReprotectAgentDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            serviceContainerId = javaType.serviceContainerId(),
            serviceEndpoint = javaType.serviceEndpoint(),
            serviceResourceId = javaType.serviceResourceId(),
            sourceAgentIdentityDetails = javaType.sourceAgentIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityProviderDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmwareSiteId = javaType.vmwareSiteId(),
        )
    }
}
