@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Initial replication details.
 * @property initialReplicationProgressPercentage The initial replication progress percentage.
 * @property initialReplicationType Initial replication type.
 */
public data class InitialReplicationDetailsResponse(
    public val initialReplicationProgressPercentage: String? = null,
    public val initialReplicationType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InitialReplicationDetailsResponse):
            InitialReplicationDetailsResponse = InitialReplicationDetailsResponse(
            initialReplicationProgressPercentage = javaType.initialReplicationProgressPercentage().map({ args0 ->
                args0
            }).orElse(null),
            initialReplicationType = javaType.initialReplicationType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
