@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointName
 * @property privatePort
 * @property protocol
 * @property publicPort
 */
public data class InputEndpointResponse(
    public val endpointName: String? = null,
    public val privatePort: Int? = null,
    public val protocol: String? = null,
    public val publicPort: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InputEndpointResponse):
            InputEndpointResponse = InputEndpointResponse(
            endpointName = javaType.endpointName().map({ args0 -> args0 }).orElse(null),
            privatePort = javaType.privatePort().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            publicPort = javaType.publicPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
