@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Disk Details.
 * @property oSMajorVersion The OS Major Version.
 * @property oSMinorVersion The OS Minor Version.
 * @property oSVersion The OS Version.
 * @property osEdition The OSEdition.
 * @property osType VM Disk details.
 * @property productType Product type.
 */
public data class OSDetailsResponse(
    public val oSMajorVersion: String? = null,
    public val oSMinorVersion: String? = null,
    public val oSVersion: String? = null,
    public val osEdition: String? = null,
    public val osType: String? = null,
    public val productType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.OSDetailsResponse):
            OSDetailsResponse = OSDetailsResponse(
            oSMajorVersion = javaType.oSMajorVersion().map({ args0 -> args0 }).orElse(null),
            oSMinorVersion = javaType.oSMinorVersion().map({ args0 -> args0 }).orElse(null),
            oSVersion = javaType.oSVersion().map({ args0 -> args0 }).orElse(null),
            osEdition = javaType.osEdition().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            productType = javaType.productType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
