@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Recovery plan script action details.
 * @property fabricLocation The fabric location.
 * @property instanceType Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
 * Expected value is 'ScriptActionDetails'.
 * @property path The script path.
 * @property timeout The script timeout.
 */
public data class RecoveryPlanScriptActionDetailsResponse(
    public val fabricLocation: String,
    public val instanceType: String,
    public val path: String,
    public val timeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanScriptActionDetailsResponse):
            RecoveryPlanScriptActionDetailsResponse = RecoveryPlanScriptActionDetailsResponse(
            fabricLocation = javaType.fabricLocation(),
            instanceType = javaType.instanceType(),
            path = javaType.path(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
