@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The retention details of the MT.
 * @property capacityInBytes The volume capacity.
 * @property freeSpaceInBytes The free space available in this volume.
 * @property thresholdPercentage The threshold percentage.
 * @property volumeName The volume name.
 */
public data class RetentionVolumeResponse(
    public val capacityInBytes: Double? = null,
    public val freeSpaceInBytes: Double? = null,
    public val thresholdPercentage: Int? = null,
    public val volumeName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RetentionVolumeResponse):
            RetentionVolumeResponse = RetentionVolumeResponse(
            capacityInBytes = javaType.capacityInBytes().map({ args0 -> args0 }).orElse(null),
            freeSpaceInBytes = javaType.freeSpaceInBytes().map({ args0 -> args0 }).orElse(null),
            thresholdPercentage = javaType.thresholdPercentage().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
