@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Security Settings of the vault
 * @property immutabilitySettings Immutability Settings of a vault
 * @property multiUserAuthorization MUA Settings of a vault
 * @property softDeleteSettings Soft delete Settings of a vault
 */
public data class SecuritySettingsResponse(
    public val immutabilitySettings: ImmutabilitySettingsResponse? = null,
    public val multiUserAuthorization: String,
    public val softDeleteSettings: SoftDeleteSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SecuritySettingsResponse):
            SecuritySettingsResponse = SecuritySettingsResponse(
            immutabilitySettings = javaType.immutabilitySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ImmutabilitySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            multiUserAuthorization = javaType.multiUserAuthorization(),
            softDeleteSettings = javaType.softDeleteSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.SoftDeleteSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
