@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * vCenter properties.
 * @property discoveryStatus The VCenter discovery status.
 * @property fabricArmResourceName The ARM resource name of the fabric containing this VCenter.
 * @property friendlyName Friendly name of the vCenter.
 * @property healthErrors The health errors for this VCenter.
 * @property infrastructureId The infrastructure Id of vCenter.
 * @property internalId VCenter internal ID.
 * @property ipAddress The IP address of the vCenter.
 * @property lastHeartbeat The time when the last heartbeat was received by vCenter.
 * @property port The port number for discovery.
 * @property processServerId The process server Id.
 * @property runAsAccountId The account Id which has privileges to discover the vCenter.
 */
public data class VCenterPropertiesResponse(
    public val discoveryStatus: String? = null,
    public val fabricArmResourceName: String? = null,
    public val friendlyName: String? = null,
    public val healthErrors: List<HealthErrorResponse>? = null,
    public val infrastructureId: String? = null,
    public val internalId: String? = null,
    public val ipAddress: String? = null,
    public val lastHeartbeat: String? = null,
    public val port: String? = null,
    public val processServerId: String? = null,
    public val runAsAccountId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VCenterPropertiesResponse):
            VCenterPropertiesResponse = VCenterPropertiesResponse(
            discoveryStatus = javaType.discoveryStatus().map({ args0 -> args0 }).orElse(null),
            fabricArmResourceName = javaType.fabricArmResourceName().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            infrastructureId = javaType.infrastructureId().map({ args0 -> args0 }).orElse(null),
            internalId = javaType.internalId().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            processServerId = javaType.processServerId().map({ args0 -> args0 }).orElse(null),
            runAsAccountId = javaType.runAsAccountId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
