@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets private link service connection state.
 * @property actionsRequired Gets or sets actions required.
 * @property description Gets or sets description.
 * @property status Gets or sets the status.
 */
public data class VaultPrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VaultPrivateLinkServiceConnectionStateResponse):
            VaultPrivateLinkServiceConnectionStateResponse =
            VaultPrivateLinkServiceConnectionStateResponse(
                actionsRequired = javaType.actionsRequired(),
                description = javaType.description(),
                status = javaType.status(),
            )
    }
}
