@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Details of an inquired protectable item.
 * @property inquiryValidation Inquiry validation such as permissions and other backup validations.
 * @property itemCount Contains the protectable item Count inside this Container.
 * @property type Type of the Workload such as SQL, Oracle etc.
 */
public data class WorkloadInquiryDetailsResponse(
    public val inquiryValidation: InquiryValidationResponse? = null,
    public val itemCount: Double? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.WorkloadInquiryDetailsResponse):
            WorkloadInquiryDetailsResponse = WorkloadInquiryDetailsResponse(
            inquiryValidation = javaType.inquiryValidation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InquiryValidationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            itemCount = javaType.itemCount().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
