@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Yearly retention schedule.
 * @property monthsOfYear List of months of year of yearly retention policy.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionScheduleDaily Daily retention format for yearly retention policy.
 * @property retentionScheduleFormatType Retention schedule format for yearly retention policy.
 * @property retentionScheduleWeekly Weekly retention format for yearly retention policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class YearlyRetentionScheduleResponse(
    public val monthsOfYear: List<String>? = null,
    public val retentionDuration: RetentionDurationResponse? = null,
    public val retentionScheduleDaily: DailyRetentionFormatResponse? = null,
    public val retentionScheduleFormatType: String? = null,
    public val retentionScheduleWeekly: WeeklyRetentionFormatResponse? = null,
    public val retentionTimes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.YearlyRetentionScheduleResponse):
            YearlyRetentionScheduleResponse = YearlyRetentionScheduleResponse(
            monthsOfYear = javaType.monthsOfYear().map({ args0 -> args0 }),
            retentionDuration = javaType.retentionDuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RetentionDurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionScheduleDaily = javaType.retentionScheduleDaily().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DailyRetentionFormatResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionScheduleFormatType = javaType.retentionScheduleFormatType().map({ args0 ->
                args0
            }).orElse(null),
            retentionScheduleWeekly = javaType.retentionScheduleWeekly().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.WeeklyRetentionFormatResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionTimes = javaType.retentionTimes().map({ args0 -> args0 }),
        )
    }
}
