@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.GetSyncSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property childResourceName The name of the SyncSet resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the OpenShift cluster resource.
 */
public data class GetSyncSetPlainArgs(
    public val childResourceName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.GetSyncSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.GetSyncSetPlainArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.GetSyncSetPlainArgs.builder()
            .childResourceName(childResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSyncSetPlainArgs].
 */
@PulumiTagMarker
public class GetSyncSetPlainArgsBuilder internal constructor() {
    private var childResourceName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the SyncSet resource.
     */
    @JvmName("xyppdsaqhgyyfbfp")
    public suspend fun childResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.childResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sexrriaewcororye")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("qqpocbjgorgjfsly")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetSyncSetPlainArgs = GetSyncSetPlainArgs(
        childResourceName = childResourceName ?: throw PulumiNullFieldException("childResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
