@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
 * @property apiserverProfile The cluster API server profile.
 * @property clusterProfile The cluster profile.
 * @property consoleProfile The console profile.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ingressProfiles The cluster ingress profiles.
 * @property location The geo-location where the resource lives
 * @property masterProfile The cluster master profile.
 * @property name The name of the resource
 * @property networkProfile The cluster network profile.
 * @property provisioningState The cluster provisioning state.
 * @property servicePrincipalProfile The cluster service principal profile.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workerProfiles The cluster worker profiles.
 */
public data class GetOpenShiftClusterResult(
    public val apiserverProfile: APIServerProfileResponse? = null,
    public val clusterProfile: ClusterProfileResponse? = null,
    public val consoleProfile: ConsoleProfileResponse? = null,
    public val id: String,
    public val ingressProfiles: List<IngressProfileResponse>? = null,
    public val location: String,
    public val masterProfile: MasterProfileResponse? = null,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val provisioningState: String? = null,
    public val servicePrincipalProfile: ServicePrincipalProfileResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val workerProfiles: List<WorkerProfileResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.GetOpenShiftClusterResult):
            GetOpenShiftClusterResult = GetOpenShiftClusterResult(
            apiserverProfile = javaType.apiserverProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.APIServerProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterProfile = javaType.clusterProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ClusterProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            consoleProfile = javaType.consoleProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ConsoleProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            ingressProfiles = javaType.ingressProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.IngressProfileResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            masterProfile = javaType.masterProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.MasterProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            servicePrincipalProfile = javaType.servicePrincipalProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ServicePrincipalProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.redhatopenshift.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            workerProfiles = javaType.workerProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.redhatopenshift.kotlin.outputs.WorkerProfileResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
