@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OpenShiftClusterCredentials represents an OpenShift cluster's credentials.
 * @property kubeadminPassword The password for the kubeadmin user.
 * @property kubeadminUsername The username for the kubeadmin user.
 */
public data class ListOpenShiftClusterCredentialsResult(
    public val kubeadminPassword: String? = null,
    public val kubeadminUsername: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.ListOpenShiftClusterCredentialsResult):
            ListOpenShiftClusterCredentialsResult = ListOpenShiftClusterCredentialsResult(
            kubeadminPassword = javaType.kubeadminPassword().map({ args0 -> args0 }).orElse(null),
            kubeadminUsername = javaType.kubeadminUsername().map({ args0 -> args0 }).orElse(null),
        )
    }
}
