@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WCFRelay].
 */
@PulumiTagMarker
public class WCFRelayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WCFRelayArgs = WCFRelayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WCFRelayArgsBuilder.() -> Unit) {
        val builder = WCFRelayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WCFRelay {
        val builtJavaResource = com.pulumi.azurenative.relay.WCFRelay(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WCFRelay(builtJavaResource)
    }
}

/**
 * Description of the WCF relay resource.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2016-07-01.
 * ## Example Usage
 * ### RelayCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var wcfRelay = new AzureNative.Relay.WCFRelay("wcfRelay", new()
 *     {
 *         NamespaceName = "example-RelayNamespace-9953",
 *         RelayName = "example-Relay-Wcf-1194",
 *         RelayType = AzureNative.Relay.Relaytype.NetTcp,
 *         RequiresClientAuthorization = true,
 *         RequiresTransportSecurity = true,
 *         ResourceGroupName = "resourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewWCFRelay(ctx, "wcfRelay", &relay.WCFRelayArgs{
 * 			NamespaceName:               pulumi.String("example-RelayNamespace-9953"),
 * 			RelayName:                   pulumi.String("example-Relay-Wcf-1194"),
 * 			RelayType:                   relay.RelaytypeNetTcp,
 * 			RequiresClientAuthorization: pulumi.Bool(true),
 * 			RequiresTransportSecurity:   pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("resourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.WCFRelay;
 * import com.pulumi.azurenative.relay.WCFRelayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wcfRelay = new WCFRelay("wcfRelay", WCFRelayArgs.builder()
 *             .namespaceName("example-RelayNamespace-9953")
 *             .relayName("example-Relay-Wcf-1194")
 *             .relayType("NetTcp")
 *             .requiresClientAuthorization(true)
 *             .requiresTransportSecurity(true)
 *             .resourceGroupName("resourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:WCFRelay example-Relay-Wcf-1194 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}
 * ```
 */
public class WCFRelay internal constructor(
    override val javaResource: com.pulumi.azurenative.relay.WCFRelay,
) : KotlinCustomResource(javaResource, WCFRelayMapper) {
    /**
     * The time the WCF relay was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Returns true if the relay is dynamic; otherwise, false.
     */
    public val isDynamic: Output<Boolean>
        get() = javaResource.isDynamic().applyValue({ args0 -> args0 })

    /**
     * The number of listeners for this relay. Note that min :1 and max:25 are supported.
     */
    public val listenerCount: Output<Int>
        get() = javaResource.listenerCount().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * WCF relay type.
     */
    public val relayType: Output<String>?
        get() = javaResource.relayType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Returns true if client authorization is needed for this relay; otherwise, false.
     */
    public val requiresClientAuthorization: Output<Boolean>?
        get() = javaResource.requiresClientAuthorization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Returns true if transport security is needed for this relay; otherwise, false.
     */
    public val requiresTransportSecurity: Output<Boolean>?
        get() = javaResource.requiresTransportSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The time the namespace was updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be used to store descriptive data, such as list of teams and their contact information. Also, user-defined configuration settings can be stored.
     */
    public val userMetadata: Output<String>?
        get() = javaResource.userMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object WCFRelayMapper : ResourceMapper<WCFRelay> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.relay.WCFRelay::class == javaResource::class

    override fun map(javaResource: Resource): WCFRelay = WCFRelay(
        javaResource as
            com.pulumi.azurenative.relay.WCFRelay,
    )
}

/**
 * @see [WCFRelay].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WCFRelay].
 */
public suspend fun wcfRelay(name: String, block: suspend WCFRelayResourceBuilder.() -> Unit):
    WCFRelay {
    val builder = WCFRelayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WCFRelay].
 * @param name The _unique_ name of the resulting resource.
 */
public fun wcfRelay(name: String): WCFRelay {
    val builder = WCFRelayResourceBuilder()
    builder.name(name)
    return builder.build()
}
