@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.WCFRelayAuthorizationRuleArgs.builder
import com.pulumi.azurenative.relay.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get AuthorizationRule operation
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2017-04-01.
 * ## Example Usage
 * ### RelayAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var wcfRelayAuthorizationRule = new AzureNative.Relay.WCFRelayAuthorizationRule("wcfRelayAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "example-RelayAuthRules-01",
 *         NamespaceName = "example-RelayNamespace-01",
 *         RelayName = "example-Relay-wcf-01",
 *         ResourceGroupName = "resourcegroup",
 *         Rights = new[]
 *         {
 *             AzureNative.Relay.AccessRights.Listen,
 *             AzureNative.Relay.AccessRights.Send,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewWCFRelayAuthorizationRule(ctx, "wcfRelayAuthorizationRule", &relay.WCFRelayAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("example-RelayAuthRules-01"),
 * 			NamespaceName:         pulumi.String("example-RelayNamespace-01"),
 * 			RelayName:             pulumi.String("example-Relay-wcf-01"),
 * 			ResourceGroupName:     pulumi.String("resourcegroup"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String(relay.AccessRightsListen),
 * 				pulumi.String(relay.AccessRightsSend),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.WCFRelayAuthorizationRule;
 * import com.pulumi.azurenative.relay.WCFRelayAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wcfRelayAuthorizationRule = new WCFRelayAuthorizationRule("wcfRelayAuthorizationRule", WCFRelayAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("example-RelayAuthRules-01")
 *             .namespaceName("example-RelayNamespace-01")
 *             .relayName("example-Relay-wcf-01")
 *             .resourceGroupName("resourcegroup")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:WCFRelayAuthorizationRule example-RelayAuthRules-01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property relayName The relay name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rights The rights associated with the rule.
 */
public data class WCFRelayAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val relayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.relay.WCFRelayAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.WCFRelayAuthorizationRuleArgs =
        com.pulumi.azurenative.relay.WCFRelayAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .relayName(relayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rights(
                rights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [WCFRelayAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class WCFRelayAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var relayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("gdkfjgmspvxxfpoo")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("xyslgvbyqnpcikuf")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The relay name.
     */
    @JvmName("tuxlldsfuaylcsng")
    public suspend fun relayName(`value`: Output<String>) {
        this.relayName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("rfbjdhlspnumjhix")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("dxyckclcgsheplqu")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("xoajdvvfxqrnsuyd")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("ixdloqtwyinhsfmc")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("dgglkqshoablscix")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("cutchyrvbikpxpxp")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name.
     */
    @JvmName("rlnecppvaogdldfy")
    public suspend fun relayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("txmixdfoooslhpby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("mgopotvrchmqjpny")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("vxyhetqsxlvggmki")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): WCFRelayAuthorizationRuleArgs = WCFRelayAuthorizationRuleArgs(
        authorizationRuleName = authorizationRuleName,
        namespaceName = namespaceName,
        relayName = relayName,
        resourceGroupName = resourceGroupName,
        rights = rights,
    )
}
