@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the Private Endpoint Connection.
 */
public enum class EndPointProvisioningState(
    public val javaValue: com.pulumi.azurenative.relay.enums.EndPointProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.relay.enums.EndPointProvisioningState> {
    Creating(com.pulumi.azurenative.relay.enums.EndPointProvisioningState.Creating),
    Updating(com.pulumi.azurenative.relay.enums.EndPointProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.relay.enums.EndPointProvisioningState.Deleting),
    Succeeded(com.pulumi.azurenative.relay.enums.EndPointProvisioningState.Succeeded),
    Canceled(com.pulumi.azurenative.relay.enums.EndPointProvisioningState.Canceled),
    Failed(com.pulumi.azurenative.relay.enums.EndPointProvisioningState.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.relay.enums.EndPointProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.enums.EndPointProvisioningState):
            EndPointProvisioningState =
            EndPointProvisioningState.values().first { it.javaValue == javaType }
    }
}
