@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if traffic is allowed over public network. By default it is enabled.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.relay.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.relay.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.relay.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.relay.enums.PublicNetworkAccess.Disabled),
    SecuredByPerimeter(com.pulumi.azurenative.relay.enums.PublicNetworkAccess.SecuredByPerimeter),
    ;

    override fun toJava(): com.pulumi.azurenative.relay.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
