@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Namespace/Relay Connection String
 * @property keyName A string that describes the authorization rule.
 * @property primaryConnectionString Primary connection string of the created namespace authorization rule.
 * @property primaryKey A base64-encoded 256-bit primary key for signing and validating the SAS token.
 * @property secondaryConnectionString Secondary connection string of the created namespace authorization rule.
 * @property secondaryKey A base64-encoded 256-bit secondary key for signing and validating the SAS token.
 */
public data class ListWCFRelayKeysResult(
    public val keyName: String? = null,
    public val primaryConnectionString: String? = null,
    public val primaryKey: String? = null,
    public val secondaryConnectionString: String? = null,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.outputs.ListWCFRelayKeysResult):
            ListWCFRelayKeysResult = ListWCFRelayKeysResult(
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            primaryConnectionString = javaType.primaryConnectionString().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            secondaryConnectionString = javaType.secondaryConnectionString().map({ args0 ->
                args0
            }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
