@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.inputs

import com.pulumi.azurenative.resourceconnector.inputs.ListApplianceKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactType This sets the type of artifact being returned, when empty no artifact endpoint is returned.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Appliances name.
 */
public data class ListApplianceKeysPlainArgs(
    public val artifactType: String? = null,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resourceconnector.inputs.ListApplianceKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resourceconnector.inputs.ListApplianceKeysPlainArgs =
        com.pulumi.azurenative.resourceconnector.inputs.ListApplianceKeysPlainArgs.builder()
            .artifactType(artifactType?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListApplianceKeysPlainArgs].
 */
@PulumiTagMarker
public class ListApplianceKeysPlainArgsBuilder internal constructor() {
    private var artifactType: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value This sets the type of artifact being returned, when empty no artifact endpoint is returned.
     */
    @JvmName("borusgocjepkdinj")
    public suspend fun artifactType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.artifactType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("osmtbiqeokjbwiks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Appliances name.
     */
    @JvmName("orbcorimxivlcjuf")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): ListApplianceKeysPlainArgs = ListApplianceKeysPlainArgs(
        artifactType = artifactType,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
