@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcegraph.kotlin

import com.pulumi.azurenative.resourcegraph.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.resourcegraph.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GraphQuery].
 */
@PulumiTagMarker
public class GraphQueryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphQueryArgs = GraphQueryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphQueryArgsBuilder.() -> Unit) {
        val builder = GraphQueryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GraphQuery {
        val builtJavaResource = com.pulumi.azurenative.resourcegraph.GraphQuery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GraphQuery(builtJavaResource)
    }
}

/**
 * Graph Query entity definition.
 * Azure REST API version: 2020-04-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * Other available API versions: 2018-09-01-preview.
 * ## Example Usage
 * ### Create Graph Query
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphQuery = new AzureNative.ResourceGraph.GraphQuery("graphQuery", new()
 *     {
 *         Description = "Docker VMs in PROD",
 *         Query = "where isnotnull(tags['Prod']) and properties.extensions[0].Name == 'docker'",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "MyDockerVMs",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resourcegraph/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourcegraph.NewGraphQuery(ctx, "graphQuery", &resourcegraph.GraphQueryArgs{
 * 			Description:       pulumi.String("Docker VMs in PROD"),
 * 			Query:             pulumi.String("where isnotnull(tags['Prod']) and properties.extensions[0].Name == 'docker'"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("MyDockerVMs"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resourcegraph.GraphQuery;
 * import com.pulumi.azurenative.resourcegraph.GraphQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphQuery = new GraphQuery("graphQuery", GraphQueryArgs.builder()
 *             .description("Docker VMs in PROD")
 *             .query("where isnotnull(tags['Prod']) and properties.extensions[0].Name == 'docker'")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("MyDockerVMs")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resourcegraph:GraphQuery MyDockerVMs /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ResourceGraph/queries/{resourceName}
 * ```
 */
public class GraphQuery internal constructor(
    override val javaResource: com.pulumi.azurenative.resourcegraph.GraphQuery,
) : KotlinCustomResource(javaResource, GraphQueryMapper) {
    /**
     * The description of a graph query.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This will be used to handle Optimistic Concurrency.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The location of the resource
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name. This is GUID value. The display name should be assigned within properties field.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * KQL query that will be graph.
     */
    public val query: Output<String>
        get() = javaResource.query().applyValue({ args0 -> args0 })

    /**
     * Enum indicating a type of graph query.
     */
    public val resultKind: Output<String>
        get() = javaResource.resultKind().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Date and time in UTC of the last modification that was made to this graph query definition.
     */
    public val timeModified: Output<String>
        get() = javaResource.timeModified().applyValue({ args0 -> args0 })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GraphQueryMapper : ResourceMapper<GraphQuery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resourcegraph.GraphQuery::class == javaResource::class

    override fun map(javaResource: Resource): GraphQuery = GraphQuery(
        javaResource as
            com.pulumi.azurenative.resourcegraph.GraphQuery,
    )
}

/**
 * @see [GraphQuery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GraphQuery].
 */
public suspend fun graphQuery(name: String, block: suspend GraphQueryResourceBuilder.() -> Unit):
    GraphQuery {
    val builder = GraphQueryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GraphQuery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graphQuery(name: String): GraphQuery {
    val builder = GraphQueryResourceBuilder()
    builder.name(name)
    return builder.build()
}
