@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcehealth.kotlin.inputs

import com.pulumi.azurenative.resourcehealth.inputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventTrackingId Event Id which uniquely identifies ServiceHealth event.
 * @property filter The filter to apply on the operation. For more information please see https://docs.microsoft.com/en-us/rest/api/apimanagement/apis?redirectedfrom=MSDN
 */
public data class ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs(
    public val eventTrackingId: String,
    public val filter: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.resourcehealth.inputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.resourcehealth.inputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs =
        com.pulumi.azurenative.resourcehealth.inputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs.builder()
            .eventTrackingId(eventTrackingId.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs].
 */
@PulumiTagMarker
public class ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgsBuilder internal
constructor() {
    private var eventTrackingId: String? = null

    private var filter: String? = null

    /**
     * @param value Event Id which uniquely identifies ServiceHealth event.
     */
    @JvmName("bqhngfbtollglqlr")
    public suspend fun eventTrackingId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventTrackingId = mapped
    }

    /**
     * @param value The filter to apply on the operation. For more information please see https://docs.microsoft.com/en-us/rest/api/apimanagement/apis?redirectedfrom=MSDN
     */
    @JvmName("udqdyaqnihamjnns")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    internal fun build(): ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs =
        ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs(
            eventTrackingId = eventTrackingId ?: throw PulumiNullFieldException("eventTrackingId"),
            filter = filter,
        )
}
