@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcehealth.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The List of eventImpactedResources operation response.
 * @property nextLink The URI to fetch the next page of events. Call ListNext() with this URI to fetch the next page of impacted resource.
 * @property value The list of eventImpactedResources.
 */
public data class ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult(
    public val nextLink: String? = null,
    public val `value`: List<EventImpactedResourceResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resourcehealth.outputs.ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult):
            ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult =
            ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult(
                nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.resourcehealth.kotlin.outputs.EventImpactedResourceResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
