@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.DeploymentAtScopeArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-07-01, 2024-03-01.
 * ## Example Usage
 * ### Create deployment at a given scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deploymentAtScope = new AzureNative.Resources.DeploymentAtScope("deploymentAtScope", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Location = "eastus",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         Scope = "providers/Microsoft.Management/managementGroups/my-management-group-id",
 *         Tags =
 *         {
 *             { "tagKey1", "tag-value-1" },
 *             { "tagKey2", "tag-value-2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeploymentAtScope(ctx, "deploymentAtScope", &resources.DeploymentAtScopeArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Location:       pulumi.String("eastus"),
 * 			Properties: &resources.DeploymentPropertiesArgs{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			Scope: pulumi.String("providers/Microsoft.Management/managementGroups/my-management-group-id"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("tag-value-1"),
 * 				"tagKey2": pulumi.String("tag-value-2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.DeploymentAtScope;
 * import com.pulumi.azurenative.resources.DeploymentAtScopeArgs;
 * import com.pulumi.azurenative.resources.inputs.DeploymentPropertiesArgs;
 * import com.pulumi.azurenative.resources.inputs.TemplateLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deploymentAtScope = new DeploymentAtScope("deploymentAtScope", DeploymentAtScopeArgs.builder()
 *             .deploymentName("my-deployment")
 *             .location("eastus")
 *             .properties(DeploymentPropertiesArgs.builder()
 *                 .mode("Incremental")
 *                 .parameters()
 *                 .templateLink(TemplateLinkArgs.builder()
 *                     .uri("https://example.com/exampleTemplate.json")
 *                     .build())
 *                 .build())
 *             .scope("providers/Microsoft.Management/managementGroups/my-management-group-id")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tag-value-1"),
 *                 Map.entry("tagKey2", "tag-value-2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:DeploymentAtScope my-deployment /{scope}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 * @property deploymentName The name of the deployment.
 * @property location The location to store the deployment data.
 * @property properties The deployment properties.
 * @property scope The resource scope.
 * @property tags Deployment tags
 */
public data class DeploymentAtScopeArgs(
    public val deploymentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<DeploymentPropertiesArgs>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.DeploymentAtScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.DeploymentAtScopeArgs =
        com.pulumi.azurenative.resources.DeploymentAtScopeArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentAtScopeArgs].
 */
@PulumiTagMarker
public class DeploymentAtScopeArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<DeploymentPropertiesArgs>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("qcxdayjnwwcaitgg")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("xbglpdyfukpntomo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("ssqxnqpffevjvnxf")
    public suspend fun properties(`value`: Output<DeploymentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource scope.
     */
    @JvmName("ubutryjtgkeqmilc")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("jqqxiqmcqamfjiai")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the deployment.
     */
    @JvmName("tamclklmmdjklnog")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("sjslnkmskyknwpos")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("oxymprnntumilele")
    public suspend fun properties(`value`: DeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The deployment properties.
     */
    @JvmName("fpjkccntmiuqvbqk")
    public suspend fun properties(argument: suspend DeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource scope.
     */
    @JvmName("llpejlioynhgnves")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("ddawasynkrclvory")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Deployment tags
     */
    @JvmName("wrcdkofdgydcjlrf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentAtScopeArgs = DeploymentAtScopeArgs(
        deploymentName = deploymentName,
        location = location,
        properties = properties,
        scope = scope,
        tags = tags,
    )
}
