@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.ResourcesFunctions.getAzureCliScriptPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getAzurePowerShellScriptPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentAtManagementGroupScopePlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentAtScopePlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentAtSubscriptionScopePlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentAtTenantScopePlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentStackAtManagementGroupPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentStackAtResourceGroupPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getDeploymentStackAtSubscriptionPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getResourceGroupPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getResourcePlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getTagAtScopePlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getTemplateSpecPlain
import com.pulumi.azurenative.resources.ResourcesFunctions.getTemplateSpecVersionPlain
import com.pulumi.azurenative.resources.kotlin.inputs.GetAzureCliScriptPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetAzureCliScriptPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetAzurePowerShellScriptPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetAzurePowerShellScriptPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtManagementGroupScopePlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtManagementGroupScopePlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtScopePlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtScopePlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtSubscriptionScopePlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtSubscriptionScopePlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtTenantScopePlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentAtTenantScopePlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentStackAtManagementGroupPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentStackAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentStackAtResourceGroupPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentStackAtResourceGroupPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentStackAtSubscriptionPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetDeploymentStackAtSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetResourceGroupPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetResourceGroupPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetResourcePlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetResourcePlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetTagAtScopePlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetTagAtScopePlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetTemplateSpecPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetTemplateSpecPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.GetTemplateSpecVersionPlainArgs
import com.pulumi.azurenative.resources.kotlin.inputs.GetTemplateSpecVersionPlainArgsBuilder
import com.pulumi.azurenative.resources.kotlin.outputs.GetAzureCliScriptResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetAzurePowerShellScriptResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtManagementGroupScopeResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtScopeResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtSubscriptionScopeResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtTenantScopeResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentStackAtManagementGroupResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentStackAtResourceGroupResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentStackAtSubscriptionResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetResourceGroupResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetResourceResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetTagAtScopeResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetTemplateSpecResult
import com.pulumi.azurenative.resources.kotlin.outputs.GetTemplateSpecVersionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.resources.kotlin.outputs.GetAzureCliScriptResult.Companion.toKotlin as getAzureCliScriptResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetAzurePowerShellScriptResult.Companion.toKotlin as getAzurePowerShellScriptResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtManagementGroupScopeResult.Companion.toKotlin as getDeploymentAtManagementGroupScopeResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtScopeResult.Companion.toKotlin as getDeploymentAtScopeResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtSubscriptionScopeResult.Companion.toKotlin as getDeploymentAtSubscriptionScopeResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentAtTenantScopeResult.Companion.toKotlin as getDeploymentAtTenantScopeResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentResult.Companion.toKotlin as getDeploymentResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentStackAtManagementGroupResult.Companion.toKotlin as getDeploymentStackAtManagementGroupResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentStackAtResourceGroupResult.Companion.toKotlin as getDeploymentStackAtResourceGroupResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetDeploymentStackAtSubscriptionResult.Companion.toKotlin as getDeploymentStackAtSubscriptionResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetResourceGroupResult.Companion.toKotlin as getResourceGroupResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetResourceResult.Companion.toKotlin as getResourceResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetTagAtScopeResult.Companion.toKotlin as getTagAtScopeResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetTemplateSpecResult.Companion.toKotlin as getTemplateSpecResultToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.GetTemplateSpecVersionResult.Companion.toKotlin as getTemplateSpecVersionResultToKotlin

public object ResourcesFunctions {
    /**
     * Gets a deployment script with a given name.
     * Azure REST API version: 2020-10-01.
     * @param argument null
     * @return Object model for the Azure CLI script.
     */
    public suspend fun getAzureCliScript(argument: GetAzureCliScriptPlainArgs):
        GetAzureCliScriptResult =
        getAzureCliScriptResultToKotlin(getAzureCliScriptPlain(argument.toJava()).await())

    /**
     * @see [getAzureCliScript].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scriptName Name of the deployment script.
     * @return Object model for the Azure CLI script.
     */
    public suspend fun getAzureCliScript(resourceGroupName: String, scriptName: String):
        GetAzureCliScriptResult {
        val argument = GetAzureCliScriptPlainArgs(
            resourceGroupName = resourceGroupName,
            scriptName = scriptName,
        )
        return getAzureCliScriptResultToKotlin(getAzureCliScriptPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureCliScript].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetAzureCliScriptPlainArgs].
     * @return Object model for the Azure CLI script.
     */
    public suspend
    fun getAzureCliScript(argument: suspend GetAzureCliScriptPlainArgsBuilder.() -> Unit):
        GetAzureCliScriptResult {
        val builder = GetAzureCliScriptPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureCliScriptResultToKotlin(getAzureCliScriptPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a deployment script with a given name.
     * Azure REST API version: 2020-10-01.
     * @param argument null
     * @return Object model for the Azure PowerShell script.
     */
    public suspend fun getAzurePowerShellScript(argument: GetAzurePowerShellScriptPlainArgs):
        GetAzurePowerShellScriptResult =
        getAzurePowerShellScriptResultToKotlin(getAzurePowerShellScriptPlain(argument.toJava()).await())

    /**
     * @see [getAzurePowerShellScript].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scriptName Name of the deployment script.
     * @return Object model for the Azure PowerShell script.
     */
    public suspend fun getAzurePowerShellScript(resourceGroupName: String, scriptName: String):
        GetAzurePowerShellScriptResult {
        val argument = GetAzurePowerShellScriptPlainArgs(
            resourceGroupName = resourceGroupName,
            scriptName = scriptName,
        )
        return getAzurePowerShellScriptResultToKotlin(getAzurePowerShellScriptPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzurePowerShellScript].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetAzurePowerShellScriptPlainArgs].
     * @return Object model for the Azure PowerShell script.
     */
    public suspend
    fun getAzurePowerShellScript(argument: suspend GetAzurePowerShellScriptPlainArgsBuilder.() -> Unit):
        GetAzurePowerShellScriptResult {
        val builder = GetAzurePowerShellScriptPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzurePowerShellScriptResultToKotlin(getAzurePowerShellScriptPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a deployment.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2016-07-01, 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Deployment information.
     */
    public suspend fun getDeployment(argument: GetDeploymentPlainArgs): GetDeploymentResult =
        getDeploymentResultToKotlin(getDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getDeployment].
     * @param deploymentName The name of the deployment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Deployment information.
     */
    public suspend fun getDeployment(deploymentName: String, resourceGroupName: String):
        GetDeploymentResult {
        val argument = GetDeploymentPlainArgs(
            deploymentName = deploymentName,
            resourceGroupName = resourceGroupName,
        )
        return getDeploymentResultToKotlin(getDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentPlainArgs].
     * @return Deployment information.
     */
    public suspend fun getDeployment(argument: suspend GetDeploymentPlainArgsBuilder.() -> Unit):
        GetDeploymentResult {
        val builder = GetDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentResultToKotlin(getDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a deployment.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Deployment information.
     */
    public suspend
    fun getDeploymentAtManagementGroupScope(argument: GetDeploymentAtManagementGroupScopePlainArgs):
        GetDeploymentAtManagementGroupScopeResult =
        getDeploymentAtManagementGroupScopeResultToKotlin(getDeploymentAtManagementGroupScopePlain(argument.toJava()).await())

    /**
     * @see [getDeploymentAtManagementGroupScope].
     * @param deploymentName The name of the deployment.
     * @param groupId The management group ID.
     * @return Deployment information.
     */
    public suspend fun getDeploymentAtManagementGroupScope(deploymentName: String, groupId: String):
        GetDeploymentAtManagementGroupScopeResult {
        val argument = GetDeploymentAtManagementGroupScopePlainArgs(
            deploymentName = deploymentName,
            groupId = groupId,
        )
        return getDeploymentAtManagementGroupScopeResultToKotlin(getDeploymentAtManagementGroupScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentAtManagementGroupScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentAtManagementGroupScopePlainArgs].
     * @return Deployment information.
     */
    public suspend
    fun getDeploymentAtManagementGroupScope(argument: suspend GetDeploymentAtManagementGroupScopePlainArgsBuilder.() -> Unit):
        GetDeploymentAtManagementGroupScopeResult {
        val builder = GetDeploymentAtManagementGroupScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentAtManagementGroupScopeResultToKotlin(getDeploymentAtManagementGroupScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a deployment.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Deployment information.
     */
    public suspend fun getDeploymentAtScope(argument: GetDeploymentAtScopePlainArgs):
        GetDeploymentAtScopeResult =
        getDeploymentAtScopeResultToKotlin(getDeploymentAtScopePlain(argument.toJava()).await())

    /**
     * @see [getDeploymentAtScope].
     * @param deploymentName The name of the deployment.
     * @param scope The resource scope.
     * @return Deployment information.
     */
    public suspend fun getDeploymentAtScope(deploymentName: String, scope: String):
        GetDeploymentAtScopeResult {
        val argument = GetDeploymentAtScopePlainArgs(
            deploymentName = deploymentName,
            scope = scope,
        )
        return getDeploymentAtScopeResultToKotlin(getDeploymentAtScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentAtScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentAtScopePlainArgs].
     * @return Deployment information.
     */
    public suspend
    fun getDeploymentAtScope(argument: suspend GetDeploymentAtScopePlainArgsBuilder.() -> Unit):
        GetDeploymentAtScopeResult {
        val builder = GetDeploymentAtScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentAtScopeResultToKotlin(getDeploymentAtScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a deployment.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Deployment information.
     */
    public suspend
    fun getDeploymentAtSubscriptionScope(argument: GetDeploymentAtSubscriptionScopePlainArgs):
        GetDeploymentAtSubscriptionScopeResult =
        getDeploymentAtSubscriptionScopeResultToKotlin(getDeploymentAtSubscriptionScopePlain(argument.toJava()).await())

    /**
     * @see [getDeploymentAtSubscriptionScope].
     * @param deploymentName The name of the deployment.
     * @return Deployment information.
     */
    public suspend fun getDeploymentAtSubscriptionScope(deploymentName: String):
        GetDeploymentAtSubscriptionScopeResult {
        val argument = GetDeploymentAtSubscriptionScopePlainArgs(
            deploymentName = deploymentName,
        )
        return getDeploymentAtSubscriptionScopeResultToKotlin(getDeploymentAtSubscriptionScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentAtSubscriptionScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentAtSubscriptionScopePlainArgs].
     * @return Deployment information.
     */
    public suspend
    fun getDeploymentAtSubscriptionScope(argument: suspend GetDeploymentAtSubscriptionScopePlainArgsBuilder.() -> Unit):
        GetDeploymentAtSubscriptionScopeResult {
        val builder = GetDeploymentAtSubscriptionScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentAtSubscriptionScopeResultToKotlin(getDeploymentAtSubscriptionScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a deployment.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Deployment information.
     */
    public suspend fun getDeploymentAtTenantScope(argument: GetDeploymentAtTenantScopePlainArgs):
        GetDeploymentAtTenantScopeResult =
        getDeploymentAtTenantScopeResultToKotlin(getDeploymentAtTenantScopePlain(argument.toJava()).await())

    /**
     * @see [getDeploymentAtTenantScope].
     * @param deploymentName The name of the deployment.
     * @return Deployment information.
     */
    public suspend fun getDeploymentAtTenantScope(deploymentName: String):
        GetDeploymentAtTenantScopeResult {
        val argument = GetDeploymentAtTenantScopePlainArgs(
            deploymentName = deploymentName,
        )
        return getDeploymentAtTenantScopeResultToKotlin(getDeploymentAtTenantScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentAtTenantScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentAtTenantScopePlainArgs].
     * @return Deployment information.
     */
    public suspend
    fun getDeploymentAtTenantScope(argument: suspend GetDeploymentAtTenantScopePlainArgsBuilder.() -> Unit):
        GetDeploymentAtTenantScopeResult {
        val builder = GetDeploymentAtTenantScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentAtTenantScopeResultToKotlin(getDeploymentAtTenantScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Deployment Stack with a given name.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return Deployment stack object.
     */
    public suspend
    fun getDeploymentStackAtManagementGroup(argument: GetDeploymentStackAtManagementGroupPlainArgs):
        GetDeploymentStackAtManagementGroupResult =
        getDeploymentStackAtManagementGroupResultToKotlin(getDeploymentStackAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getDeploymentStackAtManagementGroup].
     * @param deploymentStackName Name of the deployment stack.
     * @param managementGroupId Management Group.
     * @return Deployment stack object.
     */
    public suspend fun getDeploymentStackAtManagementGroup(
        deploymentStackName: String,
        managementGroupId: String,
    ): GetDeploymentStackAtManagementGroupResult {
        val argument = GetDeploymentStackAtManagementGroupPlainArgs(
            deploymentStackName = deploymentStackName,
            managementGroupId = managementGroupId,
        )
        return getDeploymentStackAtManagementGroupResultToKotlin(getDeploymentStackAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentStackAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentStackAtManagementGroupPlainArgs].
     * @return Deployment stack object.
     */
    public suspend
    fun getDeploymentStackAtManagementGroup(argument: suspend GetDeploymentStackAtManagementGroupPlainArgsBuilder.() -> Unit):
        GetDeploymentStackAtManagementGroupResult {
        val builder = GetDeploymentStackAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentStackAtManagementGroupResultToKotlin(getDeploymentStackAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Deployment Stack with a given name.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return Deployment stack object.
     */
    public suspend
    fun getDeploymentStackAtResourceGroup(argument: GetDeploymentStackAtResourceGroupPlainArgs):
        GetDeploymentStackAtResourceGroupResult =
        getDeploymentStackAtResourceGroupResultToKotlin(getDeploymentStackAtResourceGroupPlain(argument.toJava()).await())

    /**
     * @see [getDeploymentStackAtResourceGroup].
     * @param deploymentStackName Name of the deployment stack.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Deployment stack object.
     */
    public suspend fun getDeploymentStackAtResourceGroup(
        deploymentStackName: String,
        resourceGroupName: String,
    ): GetDeploymentStackAtResourceGroupResult {
        val argument = GetDeploymentStackAtResourceGroupPlainArgs(
            deploymentStackName = deploymentStackName,
            resourceGroupName = resourceGroupName,
        )
        return getDeploymentStackAtResourceGroupResultToKotlin(getDeploymentStackAtResourceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentStackAtResourceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentStackAtResourceGroupPlainArgs].
     * @return Deployment stack object.
     */
    public suspend
    fun getDeploymentStackAtResourceGroup(argument: suspend GetDeploymentStackAtResourceGroupPlainArgsBuilder.() -> Unit):
        GetDeploymentStackAtResourceGroupResult {
        val builder = GetDeploymentStackAtResourceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentStackAtResourceGroupResultToKotlin(getDeploymentStackAtResourceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Deployment Stack with a given name.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return Deployment stack object.
     */
    public suspend
    fun getDeploymentStackAtSubscription(argument: GetDeploymentStackAtSubscriptionPlainArgs):
        GetDeploymentStackAtSubscriptionResult =
        getDeploymentStackAtSubscriptionResultToKotlin(getDeploymentStackAtSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getDeploymentStackAtSubscription].
     * @param deploymentStackName Name of the deployment stack.
     * @return Deployment stack object.
     */
    public suspend fun getDeploymentStackAtSubscription(deploymentStackName: String):
        GetDeploymentStackAtSubscriptionResult {
        val argument = GetDeploymentStackAtSubscriptionPlainArgs(
            deploymentStackName = deploymentStackName,
        )
        return getDeploymentStackAtSubscriptionResultToKotlin(getDeploymentStackAtSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentStackAtSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetDeploymentStackAtSubscriptionPlainArgs].
     * @return Deployment stack object.
     */
    public suspend
    fun getDeploymentStackAtSubscription(argument: suspend GetDeploymentStackAtSubscriptionPlainArgsBuilder.() -> Unit):
        GetDeploymentStackAtSubscriptionResult {
        val builder = GetDeploymentStackAtSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentStackAtSubscriptionResultToKotlin(getDeploymentStackAtSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a resource.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2015-11-01, 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Resource information.
     */
    public suspend fun getResource(argument: GetResourcePlainArgs): GetResourceResult =
        getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())

    /**
     * @see [getResource].
     * @param parentResourcePath The parent resource identity.
     * @param resourceGroupName The name of the resource group containing the resource to get. The name is case insensitive.
     * @param resourceName The name of the resource to get.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param resourceType The resource type of the resource.
     * @return Resource information.
     */
    public suspend fun getResource(
        parentResourcePath: String,
        resourceGroupName: String,
        resourceName: String,
        resourceProviderNamespace: String,
        resourceType: String,
    ): GetResourceResult {
        val argument = GetResourcePlainArgs(
            parentResourcePath = parentResourcePath,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            resourceProviderNamespace = resourceProviderNamespace,
            resourceType = resourceType,
        )
        return getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetResourcePlainArgs].
     * @return Resource information.
     */
    public suspend fun getResource(argument: suspend GetResourcePlainArgsBuilder.() -> Unit):
        GetResourceResult {
        val builder = GetResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceResultToKotlin(getResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a resource group.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2018-02-01, 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Resource group information.
     */
    public suspend fun getResourceGroup(argument: GetResourceGroupPlainArgs): GetResourceGroupResult =
        getResourceGroupResultToKotlin(getResourceGroupPlain(argument.toJava()).await())

    /**
     * @see [getResourceGroup].
     * @param resourceGroupName The name of the resource group to get. The name is case insensitive.
     * @return Resource group information.
     */
    public suspend fun getResourceGroup(resourceGroupName: String): GetResourceGroupResult {
        val argument = GetResourceGroupPlainArgs(
            resourceGroupName = resourceGroupName,
        )
        return getResourceGroupResultToKotlin(getResourceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetResourceGroupPlainArgs].
     * @return Resource group information.
     */
    public suspend
    fun getResourceGroup(argument: suspend GetResourceGroupPlainArgsBuilder.() -> Unit):
        GetResourceGroupResult {
        val builder = GetResourceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceGroupResultToKotlin(getResourceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Wrapper resource for tags API requests and responses.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-07-01, 2024-03-01.
     * @param argument null
     * @return Wrapper resource for tags API requests and responses.
     */
    public suspend fun getTagAtScope(argument: GetTagAtScopePlainArgs): GetTagAtScopeResult =
        getTagAtScopeResultToKotlin(getTagAtScopePlain(argument.toJava()).await())

    /**
     * @see [getTagAtScope].
     * @param scope The resource scope.
     * @return Wrapper resource for tags API requests and responses.
     */
    public suspend fun getTagAtScope(scope: String): GetTagAtScopeResult {
        val argument = GetTagAtScopePlainArgs(
            scope = scope,
        )
        return getTagAtScopeResultToKotlin(getTagAtScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getTagAtScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetTagAtScopePlainArgs].
     * @return Wrapper resource for tags API requests and responses.
     */
    public suspend fun getTagAtScope(argument: suspend GetTagAtScopePlainArgsBuilder.() -> Unit):
        GetTagAtScopeResult {
        val builder = GetTagAtScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagAtScopeResultToKotlin(getTagAtScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Template Spec with a given name.
     * Azure REST API version: 2022-02-01.
     * @param argument null
     * @return Template Spec object.
     */
    public suspend fun getTemplateSpec(argument: GetTemplateSpecPlainArgs): GetTemplateSpecResult =
        getTemplateSpecResultToKotlin(getTemplateSpecPlain(argument.toJava()).await())

    /**
     * @see [getTemplateSpec].
     * @param expand Allows for expansion of additional Template Spec details in the response. Optional.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param templateSpecName Name of the Template Spec.
     * @return Template Spec object.
     */
    public suspend fun getTemplateSpec(
        expand: String? = null,
        resourceGroupName: String,
        templateSpecName: String,
    ): GetTemplateSpecResult {
        val argument = GetTemplateSpecPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            templateSpecName = templateSpecName,
        )
        return getTemplateSpecResultToKotlin(getTemplateSpecPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplateSpec].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetTemplateSpecPlainArgs].
     * @return Template Spec object.
     */
    public suspend fun getTemplateSpec(argument: suspend GetTemplateSpecPlainArgsBuilder.() -> Unit):
        GetTemplateSpecResult {
        val builder = GetTemplateSpecPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplateSpecResultToKotlin(getTemplateSpecPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Template Spec version from a specific Template Spec.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2019-06-01-preview.
     * @param argument null
     * @return Template Spec Version object.
     */
    public suspend fun getTemplateSpecVersion(argument: GetTemplateSpecVersionPlainArgs):
        GetTemplateSpecVersionResult =
        getTemplateSpecVersionResultToKotlin(getTemplateSpecVersionPlain(argument.toJava()).await())

    /**
     * @see [getTemplateSpecVersion].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param templateSpecName Name of the Template Spec.
     * @param templateSpecVersion The version of the Template Spec.
     * @return Template Spec Version object.
     */
    public suspend fun getTemplateSpecVersion(
        resourceGroupName: String,
        templateSpecName: String,
        templateSpecVersion: String,
    ): GetTemplateSpecVersionResult {
        val argument = GetTemplateSpecVersionPlainArgs(
            resourceGroupName = resourceGroupName,
            templateSpecName = templateSpecName,
            templateSpecVersion = templateSpecVersion,
        )
        return getTemplateSpecVersionResultToKotlin(getTemplateSpecVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplateSpecVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resources&#46;kotlin&#46;inputs&#46;GetTemplateSpecVersionPlainArgs].
     * @return Template Spec Version object.
     */
    public suspend
    fun getTemplateSpecVersion(argument: suspend GetTemplateSpecVersionPlainArgsBuilder.() -> Unit):
        GetTemplateSpecVersionResult {
        val builder = GetTemplateSpecVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplateSpecVersionResultToKotlin(getTemplateSpecVersionPlain(builtArgument.toJava()).await())
    }
}
