@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.TagsResponse
import com.pulumi.azurenative.resources.kotlin.outputs.TagsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagAtScope].
 */
@PulumiTagMarker
public class TagAtScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagAtScopeArgs = TagAtScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagAtScopeArgsBuilder.() -> Unit) {
        val builder = TagAtScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagAtScope {
        val builtJavaResource = com.pulumi.azurenative.resources.TagAtScope(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TagAtScope(builtJavaResource)
    }
}

/**
 * Wrapper resource for tags API requests and responses.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2023-07-01, 2024-03-01.
 * ## Example Usage
 * ### Update tags on a resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagAtScope = new AzureNative.Resources.TagAtScope("tagAtScope", new()
 *     {
 *         Properties = new AzureNative.Resources.Inputs.TagsArgs
 *         {
 *             Tags =
 *             {
 *                 { "tagKey1", "tag-value-1" },
 *                 { "tagKey2", "tag-value-2" },
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/myPRNameSpace/VM/myVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTagAtScope(ctx, "tagAtScope", &resources.TagAtScopeArgs{
 * 			Properties: &resources.TagsArgs{
 * 				Tags: pulumi.StringMap{
 * 					"tagKey1": pulumi.String("tag-value-1"),
 * 					"tagKey2": pulumi.String("tag-value-2"),
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/myPRNameSpace/VM/myVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TagAtScope;
 * import com.pulumi.azurenative.resources.TagAtScopeArgs;
 * import com.pulumi.azurenative.resources.inputs.TagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagAtScope = new TagAtScope("tagAtScope", TagAtScopeArgs.builder()
 *             .properties(TagsArgs.builder()
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tagKey1", "tag-value-1"),
 *                     Map.entry("tagKey2", "tag-value-2")
 *                 ))
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/myPRNameSpace/VM/myVm")
 *             .build());
 *     }
 * }
 * ```
 * ### Update tags on a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagAtScope = new AzureNative.Resources.TagAtScope("tagAtScope", new()
 *     {
 *         Properties = new AzureNative.Resources.Inputs.TagsArgs
 *         {
 *             Tags =
 *             {
 *                 { "tagKey1", "tag-value-1" },
 *                 { "tagKey2", "tag-value-2" },
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTagAtScope(ctx, "tagAtScope", &resources.TagAtScopeArgs{
 * 			Properties: &resources.TagsArgs{
 * 				Tags: pulumi.StringMap{
 * 					"tagKey1": pulumi.String("tag-value-1"),
 * 					"tagKey2": pulumi.String("tag-value-2"),
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TagAtScope;
 * import com.pulumi.azurenative.resources.TagAtScopeArgs;
 * import com.pulumi.azurenative.resources.inputs.TagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagAtScope = new TagAtScope("tagAtScope", TagAtScopeArgs.builder()
 *             .properties(TagsArgs.builder()
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tagKey1", "tag-value-1"),
 *                     Map.entry("tagKey2", "tag-value-2")
 *                 ))
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:TagAtScope myresource1 /{scope}/providers/Microsoft.Resources/tags/default
 * ```
 */
public class TagAtScope internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.TagAtScope,
) : KotlinCustomResource(javaResource, TagAtScopeMapper) {
    /**
     * The name of the tags wrapper resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of tags.
     */
    public val properties: Output<TagsResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the tags wrapper resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TagAtScopeMapper : ResourceMapper<TagAtScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.TagAtScope::class == javaResource::class

    override fun map(javaResource: Resource): TagAtScope = TagAtScope(
        javaResource as
            com.pulumi.azurenative.resources.TagAtScope,
    )
}

/**
 * @see [TagAtScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagAtScope].
 */
public suspend fun tagAtScope(name: String, block: suspend TagAtScopeResourceBuilder.() -> Unit):
    TagAtScope {
    val builder = TagAtScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagAtScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagAtScope(name: String): TagAtScope {
    val builder = TagAtScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
