@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.LinkedTemplateArtifactResponse
import com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.resources.kotlin.outputs.LinkedTemplateArtifactResponse.Companion.toKotlin as linkedTemplateArtifactResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [TemplateSpecVersion].
 */
@PulumiTagMarker
public class TemplateSpecVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateSpecVersionArgs = TemplateSpecVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateSpecVersionArgsBuilder.() -> Unit) {
        val builder = TemplateSpecVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TemplateSpecVersion {
        val builtJavaResource =
            com.pulumi.azurenative.resources.TemplateSpecVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TemplateSpecVersion(builtJavaResource)
    }
}

/**
 * Template Spec Version object.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2019-06-01-preview.
 * ## Example Usage
 * ### TemplateSpecVersionsCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateSpecVersion = new AzureNative.Resources.TemplateSpecVersion("templateSpecVersion", new()
 *     {
 *         Description = "This is version v1.0 of our template content",
 *         Location = "eastus",
 *         MainTemplate = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "http://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#",
 *             ["contentVersion"] = "1.0.0.0",
 *             ["parameters"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["resources"] = new[]
 *             {
 *             },
 *         },
 *         ResourceGroupName = "templateSpecRG",
 *         TemplateSpecName = "simpleTemplateSpec",
 *         TemplateSpecVersion = "v1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTemplateSpecVersion(ctx, "templateSpecVersion", &resources.TemplateSpecVersionArgs{
 * 			Description: pulumi.String("This is version v1.0 of our template content"),
 * 			Location:    pulumi.String("eastus"),
 * 			MainTemplate: pulumi.Any(map[string]interface{}{
 * 				"$schema":        "http://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#",
 * 				"contentVersion": "1.0.0.0",
 * 				"parameters":     nil,
 * 				"resources":      []interface{}{},
 * 			}),
 * 			ResourceGroupName:   pulumi.String("templateSpecRG"),
 * 			TemplateSpecName:    pulumi.String("simpleTemplateSpec"),
 * 			TemplateSpecVersion: pulumi.String("v1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TemplateSpecVersion;
 * import com.pulumi.azurenative.resources.TemplateSpecVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateSpecVersion = new TemplateSpecVersion("templateSpecVersion", TemplateSpecVersionArgs.builder()
 *             .description("This is version v1.0 of our template content")
 *             .location("eastus")
 *             .mainTemplate(Map.ofEntries(
 *                 Map.entry("$schema", "http://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#"),
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("resources", )
 *             ))
 *             .resourceGroupName("templateSpecRG")
 *             .templateSpecName("simpleTemplateSpec")
 *             .templateSpecVersion("v1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:TemplateSpecVersion v1.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions/{templateSpecVersion}
 * ```
 */
public class TemplateSpecVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.TemplateSpecVersion,
) : KotlinCustomResource(javaResource, TemplateSpecVersionMapper) {
    /**
     * Template Spec version description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array of linked template artifacts.
     */
    public val linkedTemplates: Output<List<LinkedTemplateArtifactResponse>>?
        get() = javaResource.linkedTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        linkedTemplateArtifactResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The location of the Template Spec Version. It must match the location of the parent Template Spec.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The main Azure Resource Manager template content.
     */
    public val mainTemplate: Output<Any>?
        get() = javaResource.mainTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Azure Resource Manager template UI definition content.
     */
    public val uiFormDefinition: Output<Any>?
        get() = javaResource.uiFormDefinition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TemplateSpecVersionMapper : ResourceMapper<TemplateSpecVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.TemplateSpecVersion::class == javaResource::class

    override fun map(javaResource: Resource): TemplateSpecVersion = TemplateSpecVersion(
        javaResource
            as com.pulumi.azurenative.resources.TemplateSpecVersion,
    )
}

/**
 * @see [TemplateSpecVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateSpecVersion].
 */
public suspend fun templateSpecVersion(
    name: String,
    block: suspend TemplateSpecVersionResourceBuilder.() -> Unit,
): TemplateSpecVersion {
    val builder = TemplateSpecVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateSpecVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateSpecVersion(name: String): TemplateSpecVersion {
    val builder = TemplateSpecVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
