@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The identity type.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.resources.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.resources.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.resources.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.resources.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.resources.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.resources.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.resources.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.enums.ResourceIdentityType):
            ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
