@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.DenySettingsArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.DenySettingsMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *  /*
 * Defines how resources deployed by the deployment stack are locked.
 * @property applyToChildScopes DenySettings will be applied to child scopes.
 * @property excludedActions List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
 * @property excludedPrincipals List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
 * @property mode denySettings Mode.
 */
public data class DenySettingsArgs(
    public val applyToChildScopes: Output<Boolean>? = null,
    public val excludedActions: Output<List<String>>? = null,
    public val excludedPrincipals: Output<List<String>>? = null,
    public val mode: Output<Either<String, DenySettingsMode>>,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.DenySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.DenySettingsArgs =
        com.pulumi.azurenative.resources.inputs.DenySettingsArgs.builder()
            .applyToChildScopes(applyToChildScopes?.applyValue({ args0 -> args0 }))
            .excludedActions(excludedActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedPrincipals(excludedPrincipals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mode(
                mode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DenySettingsArgs].
 */
@PulumiTagMarker
public class DenySettingsArgsBuilder internal constructor() {
    private var applyToChildScopes: Output<Boolean>? = null

    private var excludedActions: Output<List<String>>? = null

    private var excludedPrincipals: Output<List<String>>? = null

    private var mode: Output<Either<String, DenySettingsMode>>? = null

    /**
     * @param value DenySettings will be applied to child scopes.
     */
    @JvmName("ttaijshmkjtjbkyy")
    public suspend fun applyToChildScopes(`value`: Output<Boolean>) {
        this.applyToChildScopes = value
    }

    /**
     *  /*
     * @param value List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
     */
    @JvmName("ayrjkkmjijjkkyql")
    public suspend fun excludedActions(`value`: Output<List<String>>) {
        this.excludedActions = value
    }

    @JvmName("wgohuxgyuapcivsj")
    public suspend fun excludedActions(vararg values: Output<String>) {
        this.excludedActions = Output.all(values.asList())
    }

    /**
     *  /*
     * @param values List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
     */
    @JvmName("batohbslxmcqmfev")
    public suspend fun excludedActions(values: List<Output<String>>) {
        this.excludedActions = Output.all(values)
    }

    /**
     * @param value List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
     */
    @JvmName("bqmuscbjqgvikvhg")
    public suspend fun excludedPrincipals(`value`: Output<List<String>>) {
        this.excludedPrincipals = value
    }

    @JvmName("vmqfcvssyowvooyo")
    public suspend fun excludedPrincipals(vararg values: Output<String>) {
        this.excludedPrincipals = Output.all(values.asList())
    }

    /**
     * @param values List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
     */
    @JvmName("kumijcpsyetqbkgi")
    public suspend fun excludedPrincipals(values: List<Output<String>>) {
        this.excludedPrincipals = Output.all(values)
    }

    /**
     * @param value denySettings Mode.
     */
    @JvmName("ejrefghtcsysoiui")
    public suspend fun mode(`value`: Output<Either<String, DenySettingsMode>>) {
        this.mode = value
    }

    /**
     * @param value DenySettings will be applied to child scopes.
     */
    @JvmName("sndifeuurrlnqfji")
    public suspend fun applyToChildScopes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyToChildScopes = mapped
    }

    /**
     *  /*
     * @param value List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
     */
    @JvmName("haadnatwyskycnhq")
    public suspend fun excludedActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedActions = mapped
    }

    /**
     *  /*
     * @param values List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
     */
    @JvmName("aqvxiuvqxyrryecf")
    public suspend fun excludedActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedActions = mapped
    }

    /**
     * @param value List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
     */
    @JvmName("uycwdcvehchejelt")
    public suspend fun excludedPrincipals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedPrincipals = mapped
    }

    /**
     * @param values List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
     */
    @JvmName("vgbvsujgqstscufw")
    public suspend fun excludedPrincipals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedPrincipals = mapped
    }

    /**
     * @param value denySettings Mode.
     */
    @JvmName("lbmtocrcvrlxkwyn")
    public suspend fun mode(`value`: Either<String, DenySettingsMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value denySettings Mode.
     */
    @JvmName("nonimxeefyrbwxgp")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DenySettingsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value denySettings Mode.
     */
    @JvmName("ykhtbpebworfkjqu")
    public fun mode(`value`: DenySettingsMode) {
        val toBeMapped = Either.ofRight<String, DenySettingsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): DenySettingsArgs = DenySettingsArgs(
        applyToChildScopes = applyToChildScopes,
        excludedActions = excludedActions,
        excludedPrincipals = excludedPrincipals,
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
