@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.DeploymentParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Deployment parameter for the template.
 * @property reference Azure Key Vault parameter reference.
 * @property value Input value to the parameter .
 */
public data class DeploymentParameterArgs(
    public val reference: Output<KeyVaultParameterReferenceArgs>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.DeploymentParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.DeploymentParameterArgs =
        com.pulumi.azurenative.resources.inputs.DeploymentParameterArgs.builder()
            .reference(reference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentParameterArgs].
 */
@PulumiTagMarker
public class DeploymentParameterArgsBuilder internal constructor() {
    private var reference: Output<KeyVaultParameterReferenceArgs>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Azure Key Vault parameter reference.
     */
    @JvmName("dwhysuwqeygqvtjj")
    public suspend fun reference(`value`: Output<KeyVaultParameterReferenceArgs>) {
        this.reference = value
    }

    /**
     * @param value Input value to the parameter .
     */
    @JvmName("ghwyopwwhxmwnlpn")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Azure Key Vault parameter reference.
     */
    @JvmName("hnmcxytxlqftsbng")
    public suspend fun reference(`value`: KeyVaultParameterReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reference = mapped
    }

    /**
     * @param argument Azure Key Vault parameter reference.
     */
    @JvmName("ekwptlexmkcmvifq")
    public suspend fun reference(argument: suspend KeyVaultParameterReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultParameterReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reference = mapped
    }

    /**
     * @param value Input value to the parameter .
     */
    @JvmName("pbsvhuooqnvyudrv")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DeploymentParameterArgs = DeploymentParameterArgs(
        reference = reference,
        `value` = `value`,
    )
}
