@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentStackName Name of the deployment stack.
 * @property managementGroupId Management Group.
 */
public data class GetDeploymentStackAtManagementGroupPlainArgs(
    public val deploymentStackName: String,
    public val managementGroupId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtManagementGroupPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtManagementGroupPlainArgs.builder()
            .deploymentStackName(deploymentStackName.let({ args0 -> args0 }))
            .managementGroupId(managementGroupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentStackAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentStackAtManagementGroupPlainArgsBuilder internal constructor() {
    private var deploymentStackName: String? = null

    private var managementGroupId: String? = null

    /**
     * @param value Name of the deployment stack.
     */
    @JvmName("mnddsikvixbivxmu")
    public suspend fun deploymentStackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentStackName = mapped
    }

    /**
     * @param value Management Group.
     */
    @JvmName("ajfpbywregeoeruh")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    internal fun build(): GetDeploymentStackAtManagementGroupPlainArgs =
        GetDeploymentStackAtManagementGroupPlainArgs(
            deploymentStackName = deploymentStackName ?: throw PulumiNullFieldException("deploymentStackName"),
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
        )
}
