@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentStackName Name of the deployment stack.
 */
public data class GetDeploymentStackAtSubscriptionPlainArgs(
    public val deploymentStackName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtSubscriptionPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtSubscriptionPlainArgs.builder()
            .deploymentStackName(deploymentStackName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentStackAtSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentStackAtSubscriptionPlainArgsBuilder internal constructor() {
    private var deploymentStackName: String? = null

    /**
     * @param value Name of the deployment stack.
     */
    @JvmName("stvfygkexhrlgcsa")
    public suspend fun deploymentStackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentStackName = mapped
    }

    internal fun build(): GetDeploymentStackAtSubscriptionPlainArgs =
        GetDeploymentStackAtSubscriptionPlainArgs(
            deploymentStackName = deploymentStackName ?: throw PulumiNullFieldException("deploymentStackName"),
        )
}
