@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetTagAtScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scope The resource scope.
 */
public data class GetTagAtScopePlainArgs(
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetTagAtScopePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetTagAtScopePlainArgs =
        com.pulumi.azurenative.resources.inputs.GetTagAtScopePlainArgs.builder()
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagAtScopePlainArgs].
 */
@PulumiTagMarker
public class GetTagAtScopePlainArgsBuilder internal constructor() {
    private var scope: String? = null

    /**
     * @param value The resource scope.
     */
    @JvmName("qescvxhakbuyjypy")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetTagAtScopePlainArgs = GetTagAtScopePlainArgs(
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
