@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.TemplateLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Entity representing the reference to the template.
 * @property contentVersion If included, must match the ContentVersion in the template.
 * @property id The resource id of a Template Spec. Use either the id or uri property, but not both.
 * @property queryString The query string (for example, a SAS token) to be used with the templateLink URI.
 * @property relativePath The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath URIs
 * @property uri The URI of the template to deploy. Use either the uri or id property, but not both.
 */
public data class TemplateLinkArgs(
    public val contentVersion: Output<String>? = null,
    public val id: Output<String>? = null,
    public val queryString: Output<String>? = null,
    public val relativePath: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.TemplateLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.TemplateLinkArgs =
        com.pulumi.azurenative.resources.inputs.TemplateLinkArgs.builder()
            .contentVersion(contentVersion?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .queryString(queryString?.applyValue({ args0 -> args0 }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateLinkArgs].
 */
@PulumiTagMarker
public class TemplateLinkArgsBuilder internal constructor() {
    private var contentVersion: Output<String>? = null

    private var id: Output<String>? = null

    private var queryString: Output<String>? = null

    private var relativePath: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value If included, must match the ContentVersion in the template.
     */
    @JvmName("vdypxybapreebvow")
    public suspend fun contentVersion(`value`: Output<String>) {
        this.contentVersion = value
    }

    /**
     * @param value The resource id of a Template Spec. Use either the id or uri property, but not both.
     */
    @JvmName("isssgtjfrvjmborn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The query string (for example, a SAS token) to be used with the templateLink URI.
     */
    @JvmName("aujcpkxvrsdfrclq")
    public suspend fun queryString(`value`: Output<String>) {
        this.queryString = value
    }

    /**
     * @param value The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath URIs
     */
    @JvmName("kbnewqexhcyioesh")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value The URI of the template to deploy. Use either the uri or id property, but not both.
     */
    @JvmName("fnqfimvgysunlqxj")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value If included, must match the ContentVersion in the template.
     */
    @JvmName("fmbykdjqreopfrgi")
    public suspend fun contentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentVersion = mapped
    }

    /**
     * @param value The resource id of a Template Spec. Use either the id or uri property, but not both.
     */
    @JvmName("fwivkqoscalhdiir")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The query string (for example, a SAS token) to be used with the templateLink URI.
     */
    @JvmName("nbnnvdbspexqmkgc")
    public suspend fun queryString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param value The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath URIs
     */
    @JvmName("edvnbkvbwcixhnoa")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value The URI of the template to deploy. Use either the uri or id property, but not both.
     */
    @JvmName("rtglutlrrnjbogkn")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): TemplateLinkArgs = TemplateLinkArgs(
        contentVersion = contentVersion,
        id = id,
        queryString = queryString,
        relativePath = relativePath,
        uri = uri,
    )
}
