@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Deployment dependency information.
 * @property id The ID of the dependency.
 * @property resourceName The dependency resource name.
 * @property resourceType The dependency resource type.
 */
public data class BasicDependencyResponse(
    public val id: String? = null,
    public val resourceName: String? = null,
    public val resourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.BasicDependencyResponse):
            BasicDependencyResponse = BasicDependencyResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
